module Model exposing (..)

import QRCode
import QRTypes exposing (QRType)


type alias Model =
    { qrType : QRType
    , errorCorrection : QRCode.ErrorCorrection
    , qrStyle : QRStyle
    , hoveredFont : Maybe String
    , fontDropdownOpen : Bool
    }


type alias QRStyle =
    { foregroundColor : String
    , backgroundColor : String
    , cornerRadius : Float
    , moduleScale : Float
    , centerContent : CenterContent
    , size : Int
    }


type CenterContent
    = NoCenterContent
    | CenterImage CenterImageConfig
    | CenterText CenterTextConfig


type alias CenterImageConfig =
    { url : String
    , size : Int  -- Percentage of QR code size (10-50%)
    , backgroundColor : String
    , borderColor : String
    , borderWidth : Int
    , borderRadius : Float
    }


type alias CenterTextConfig =
    { text : String
    , fontSize : Int
    , fontFamily : String
    , fontWeight : String  -- "normal", "bold"
    , fontStyle : String   -- "normal", "italic"
    , textColor : String
    , backgroundColor : String
    , padding : Int
    , borderRadius : Float
    , borderColor : String
    , borderWidth : Int
    }
